/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.dictionaries.furniture;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;

@Singleton
public class FurnitureLayoutDictionary {
    private Map<String, FurnitureLayout> byName = new HashMap<String, FurnitureLayout>();
    public static FurnitureLayout NULL_LAYOUT = new FurnitureLayout();

    @Inject
    public FurnitureLayoutDictionary() throws IOException {
        this(new File("assets/definitions/furnitureLayouts.json"));
    }

    public FurnitureLayoutDictionary(File jsonFile) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        List layouts = (List)objectMapper.readValue(FileUtils.readFileToString(jsonFile, "UTF-8"), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, FurnitureLayout.class));
        for (FurnitureLayout layout : layouts) {
            this.byName.put(layout.getUniqueName(), layout);
        }
        for (FurnitureLayout layout : layouts) {
            if (layout.getRotatesToName() == null) continue;
            layout.setRotatesTo(this.byName.get(layout.getRotatesToName()));
        }
        this.byName.put(NULL_LAYOUT.getUniqueName(), NULL_LAYOUT);
    }

    public FurnitureLayout getByName(String name) {
        return this.byName.get(name);
    }

    public Collection<FurnitureLayout> getAll() {
        return this.byName.values();
    }

    static {
        NULL_LAYOUT.setUniqueName("Null category");
    }
}

